<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-100 leading-tight">
            {{ __('Registro de Médicos e Instituciones') }}
        </h2>
    </x-slot>

    <div class="py-8" x-data="doctorsPage(@js($insurers), @js($ncfTypes))">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">

            @if (session('success'))
                <div class="mb-4 rounded-lg bg-green-50 dark:bg-green-900/30 p-4 text-green-800 dark:text-green-200">
                    {{ session('success') }}
                </div>
            @endif

            @if ($errors->any())
                <div class="mb-4 rounded-lg bg-red-50 dark:bg-red-900/30 p-4 text-red-800 dark:text-red-200">
                    <div class="font-semibold mb-2">Revisa estos campos:</div>
                    <ul class="list-disc ml-5">
                        @foreach ($errors->all() as $error)
                            <li class="text-sm">{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <div class="bg-white dark:bg-gray-800 shadow-sm sm:rounded-lg p-6">
                <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-3">
                    <form method="GET" class="flex-1">
                        <input name="q" value="{{ $q }}"
                            class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                   focus:border-indigo-500 focus:ring-indigo-500"
                            placeholder="Buscar médicos o instituciones..." />
                    </form>

                    <button type="button" @click="openCreate()"
                        class="inline-flex items-center justify-center rounded-lg bg-blue-600 px-4 py-2 text-white font-medium hover:bg-blue-700">
                        + Nuevo Médico
                    </button>
                </div>

                <div class="mt-6 overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="text-gray-600 dark:text-gray-300">
                            <tr class="border-b border-gray-200 dark:border-gray-700">
                                <th class="py-3 text-left font-semibold">Nombre</th>
                                <th class="py-3 text-left font-semibold">Especialidades</th>
                                <th class="py-3 text-left font-semibold">Institución</th>
                                <th class="py-3 text-left font-semibold">Teléfono</th>
                                <th class="py-3 text-left font-semibold">Email</th>
                                <th class="py-3 text-right font-semibold">Acciones</th>
                            </tr>
                        </thead>

                        <tbody class="text-gray-800 dark:text-gray-100">
                            @forelse ($doctors as $d)
                                <tr class="border-b border-gray-200 dark:border-gray-700">
                                    <td class="py-3 font-medium">
                                        <div class="flex flex-col">
                                            <span>{{ $d->full_name }}</span>
                                            <span class="text-xs text-gray-500 dark:text-gray-400">RNC/Cédula:
                                                {{ $d->rnc }}</span>
                                        </div>
                                    </td>
                                    <td class="py-3">{{ $d->specialty }}</td>
                                    <td class="py-3">{{ $d->institution }}</td>
                                    <td class="py-3">{{ $d->phone }}</td>
                                    <td class="py-3">{{ $d->email }}</td>
                                    <td class="py-3 text-right space-x-2">
                                        <button type="button"
                                            class="inline-flex items-center rounded-md px-3 py-2 text-amber-700 dark:text-amber-300 bg-amber-50 dark:bg-amber-900/20 hover:bg-amber-100 dark:hover:bg-amber-900/30"
                                            @click="openEdit({
                                                id: {{ $d->id }},
                                                rnc: @js($d->rnc),
                                                full_name: @js($d->full_name),
                                                specialty: @js($d->specialty),
                                                institution: @js($d->institution),
                                                phone: @js($d->phone),
                                                email: @js($d->email),
                                                insurers_pivot: @js($d->insurers->filter(fn($i) => filled($i->pivot->doctor_code))->mapWithKeys(fn($i) => [(string) $i->id => $i->pivot->doctor_code])),
                                                ncf: @js(
    $d->ncfAuthorizations->keyBy('ncf_type_id')->map(
        fn($a) => [
            'active' => (bool) $a->active,
            'from_number' => $a->from_number,
            'to_number' => $a->to_number,
            'requested_at' => optional($a->requested_at)->format('Y-m-d'),
            'expires_at' => optional($a->expires_at)->format('Y-m-d'),
        ],
    ),
),
                                            })">
                                            ✏️ Editar
                                        </button>

                                        <form method="POST" action="{{ route('doctors.destroy', $d) }}" class="inline"
                                            onsubmit="return confirm('¿Eliminar este médico?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit"
                                                class="inline-flex items-center rounded-md px-3 py-2 text-red-700 dark:text-red-300 bg-red-50 dark:bg-red-900/20 hover:bg-red-100 dark:hover:bg-red-900/30">
                                                🗑️
                                            </button>
                                        </form>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="py-10 text-center text-gray-500 dark:text-gray-400">
                                        No hay médicos registrados.
                                    </td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $doctors->links() }}
                </div>
            </div>
        </div>

        <!-- MODAL -->
        <div x-show="modalOpen" x-transition.opacity class="fixed inset-0 z-50 bg-black/50 px-4 py-6 overflow-y-auto"
            style="display: none;">
            <div class="min-h-full flex items-center justify-center">

                <div x-transition @click.outside="closeModal()"
                    class="w-full max-w-3xl rounded-xl bg-white dark:bg-gray-800 shadow-lg
       max-h-[calc(100vh-3rem)] overflow-hidden">
                    <div class="flex items-center justify-between border-b border-gray-200 dark:border-gray-700 p-5">
                        <h3 class="text-lg font-semibold text-gray-900 dark:text-gray-100"
                            x-text="isEdit ? 'Editar registro de médicos' : 'Nuevo registro de médicos'">
                        </h3>

                        <button class="text-gray-500 hover:text-gray-800 dark:text-gray-300 dark:hover:text-white"
                            @click="closeModal()">
                            ✕
                        </button>
                    </div>

                    <form :action="formAction" method="POST" class="p-5 overflow-y-auto"
                        style="max-height: calc(100vh - 14rem);">
                        @csrf
                        <template x-if="isEdit">
                            <input type="hidden" name="_method" value="PUT">
                        </template>

                        <!-- DATOS -->
                        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                            <div>
                                <label class="block text-sm font-medium text-gray-700 dark:text-gray-200 mb-1">RNC /
                                    Cédula</label>
                                <input name="rnc" x-model="form.rnc"
                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                          focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="Ingrese el RNC" required>
                            </div>

                            <div>
                                <label
                                    class="block text-sm font-medium text-gray-700 dark:text-gray-200 mb-1">Nombre</label>
                                <input name="full_name" x-model="form.full_name"
                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                          focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="Nombre completo" required>
                            </div>

                            <div>
                                <label
                                    class="block text-sm font-medium text-gray-700 dark:text-gray-200 mb-1">Especialidad</label>
                                <input name="specialty" x-model="form.specialty"
                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                          focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="Especialidad médica">
                            </div>

                            <div>
                                <label
                                    class="block text-sm font-medium text-gray-700 dark:text-gray-200 mb-1">Institución</label>
                                <input name="institution" x-model="form.institution"
                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                          focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="Nombre de la Institución">
                            </div>

                            <div>
                                <label
                                    class="block text-sm font-medium text-gray-700 dark:text-gray-200 mb-1">Teléfono</label>
                                <input name="phone" x-model="form.phone"
                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                          focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="Teléfono de contacto">
                            </div>

                            <div>
                                <label
                                    class="block text-sm font-medium text-gray-700 dark:text-gray-200 mb-1">Email</label>
                                <input name="email" type="email" x-model="form.email"
                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                          focus:border-indigo-500 focus:ring-indigo-500"
                                    placeholder="Correo electrónico">
                            </div>
                        </div>

                        <!-- TABS -->
                        <div class="mt-6">
                            <div class="flex rounded-lg overflow-hidden border border-gray-200 dark:border-gray-700">
                                <button type="button" class="flex-1 px-4 py-2 text-sm font-medium"
                                    :class="tab === 'insurers' ?
                                        'bg-gray-700 text-white' :
                                        'bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700/30'"
                                    @click="tab='insurers'">
                                    Aseguradoras
                                </button>

                                <button type="button" class="flex-1 px-4 py-2 text-sm font-medium"
                                    :class="tab === 'ncf' ?
                                        'bg-gray-700 text-white' :
                                        'bg-white dark:bg-gray-800 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-700/30'"
                                    @click="tab='ncf'">
                                    Comprobantes Fiscales
                                </button>
                            </div>
                        </div>

                        <!-- TAB ASEGURADORAS -->
                        <div class="mt-4" x-show="tab==='insurers'">
                            <div class="text-sm font-semibold text-gray-900 dark:text-gray-100 mb-2">Aseguradoras
                                Aceptadas</div>

                            <div class="space-y-3 max-h-64 overflow-auto pr-1">
                                <template x-for="ins in insurers" :key="ins.id">
                                    <div class="rounded-lg border border-gray-200 dark:border-gray-700 p-4"
                                        x-data="{ enabled: false }" x-effect="enabled = isSelected(ins.id)">

                                        <div class="flex items-start gap-3">
                                            <input type="checkbox"
                                                class="mt-1 rounded border-gray-300 dark:border-gray-700"
                                                x-model="enabled" @change="toggleInsurer(ins.id, enabled)">

                                            <div class="flex-1">
                                                <div class="flex items-center justify-between gap-2">
                                                    <div class="font-semibold text-gray-900 dark:text-gray-100"
                                                        x-text="ins.name"></div>
                                                    <div class="text-xs text-gray-500 dark:text-gray-400">Factura / NCF
                                                    </div>
                                                </div>

                                                <!-- Código del médico (solo si enabled=true) -->
                                                <div class="mt-3" x-show="enabled" x-transition>
                                                    <label
                                                        class="block text-xs font-medium text-gray-700 dark:text-gray-200 mb-1">
                                                        Código del Médico
                                                    </label>

                                                    <input :name="`insurers[${ins.id}]`"
                                                        x-model="form.insurers[ins.id]"
                                                        class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                               focus:border-indigo-500 focus:ring-indigo-500"
                                                        placeholder="Ingrese el código del médico">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </template>



                            </div>
                        </div>

                        <!-- TAB NCF (placeholder por ahora) -->
                        <div class="mt-4" x-show="tab==='ncf'">
                            <div class="text-sm font-semibold text-gray-900 dark:text-gray-100 mb-2">
                                Comprobantes Fiscales (NCF del médico)
                            </div>

                            <div class="space-y-3">
                                <template x-for="t in ncfTypes" :key="'type-' + t.id">
                                    <div class="rounded-lg border border-gray-200 dark:border-gray-700 p-4">
                                        <div class="flex items-center justify-between gap-3">
                                            <div>
                                                <div class="text-sm font-semibold text-gray-900 dark:text-gray-100"
                                                    x-text="t.name"></div>
                                                <div class="text-xs text-gray-500 dark:text-gray-400"
                                                    x-text="'Prefijo: ' + t.prefix"></div>
                                            </div>

                                            <label
                                                class="inline-flex items-center gap-2 text-sm text-gray-700 dark:text-gray-200">
                                                <input type="hidden" :name="`ncf[${t.id}][active]`" value="0">
<input type="checkbox" :name="`ncf[${t.id}][active]`" value="1"
       x-model="form.ncf[t.id].active" class="rounded border-gray-300 dark:border-gray-700">
                                                Activo
                                            </label>
                                        </div>

                                        <div class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4"
                                            x-show="form.ncf[t.id].active" x-transition>
                                            <div>
                                                <label
                                                    class="block text-xs font-medium text-gray-700 dark:text-gray-200 mb-1">Número
                                                    Desde</label>
                                                <input
                                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                   focus:border-indigo-500 focus:ring-indigo-500"
                                                    :name="`ncf[${t.id}][from_number]`"
                                                    x-model="form.ncf[t.id].from_number"
                                                    placeholder="Ej: B0100000124">
                                            </div>

                                            <div>
                                                <label
                                                    class="block text-xs font-medium text-gray-700 dark:text-gray-200 mb-1">Número
                                                    Hasta</label>
                                                <input
                                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                   focus:border-indigo-500 focus:ring-indigo-500"
                                                    :name="`ncf[${t.id}][to_number]`"
                                                    x-model="form.ncf[t.id].to_number" placeholder="Ej: B0100000147">
                                            </div>

                                            <div>
                                                <label
                                                    class="block text-xs font-medium text-gray-700 dark:text-gray-200 mb-1">Fecha
                                                    Solicitud</label>
                                                <input type="date"
                                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                   focus:border-indigo-500 focus:ring-indigo-500"
                                                    :name="`ncf[${t.id}][requested_at]`"
                                                    x-model="form.ncf[t.id].requested_at">
                                            </div>

                                            <div>
                                                <label
                                                    class="block text-xs font-medium text-gray-700 dark:text-gray-200 mb-1">Fecha
                                                    Vencimiento</label>
                                                <input type="date"
                                                    class="w-full rounded-lg border-gray-300 dark:border-gray-700 dark:bg-gray-900 dark:text-gray-100
                                   focus:border-indigo-500 focus:ring-indigo-500"
                                                    :name="`ncf[${t.id}][expires_at]`"
                                                    x-model="form.ncf[t.id].expires_at">
                                            </div>
                                        </div>
                                    </div>
                                </template>
                            </div>
                        </div>



                        <!-- FOOTER -->
                        <div
                            class="mt-6 flex items-center justify-end gap-3 border-t border-gray-200 dark:border-gray-700 pt-4">
                            <button type="button"
                                class="rounded-lg border border-gray-300 dark:border-gray-700 px-4 py-2 text-gray-700 dark:text-gray-200
                                       hover:bg-gray-50 dark:hover:bg-gray-700/30"
                                @click="closeModal()">
                                Cancelar
                            </button>

                            <button type="submit"
                                class="rounded-lg bg-blue-600 px-4 py-2 text-white font-medium hover:bg-blue-700">
                                Guardar
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <script>
            function doctorsPage(insurers, ncfTypes) {
                return {
                    insurers: insurers || [],
                    ncfTypes: ncfTypes || [],

                    modalOpen: false,
                    isEdit: false,
                    tab: 'insurers',

                    formAction: "{{ route('doctors.store') }}",
                    form: {
                        id: null,
                        rnc: '',
                        full_name: '',
                        specialty: '',
                        institution: '',
                        phone: '',
                        email: '',
                        insurers: {},
                        ncf: {}
                    },

                    initNcfStructure() {
                        this.form.ncf = this.form.ncf || {};

                        this.ncfTypes.forEach(t => {
                            const k = String(t.id);
                            if (!this.form.ncf[k]) {
                                this.form.ncf[k] = {
                                    active: false,
                                    number_from: '',
                                    number_to: '',
                                    request_date: '',
                                    expiration_date: ''
                                };
                            }
                        });
                    },


                    openCreate() {
                        this.isEdit = false;
                        this.tab = 'insurers';
                        this.formAction = "{{ route('doctors.store') }}";
                        this.form = {
                            id: null,
                            rnc: '',
                            full_name: '',
                            specialty: '',
                            institution: '',
                            phone: '',
                            email: '',
                            insurers: {},
                            ncf: {}
                        };
                        this.initNcfStructure();
                        this.modalOpen = true;
                    },

                    openEdit(item) {
                        this.isEdit = true;
                        this.tab = 'insurers';
                        this.formAction = `/doctors/${item.id}`;

                        this.form = {
                            id: item.id,
                            rnc: item.rnc ?? '',
                            full_name: item.full_name ?? '',
                            specialty: item.specialty ?? '',
                            institution: item.institution ?? '',
                            phone: item.phone ?? '',
                            email: item.email ?? '',
                            insurers: item.insurers_pivot ?? {},
                            ncf: item.ncf ?? {}
                        };

                        this.initNcfStructure();
                        this.modalOpen = true;
                    },

                    closeModal() {
                        this.modalOpen = false;
                    },

                    isSelected(insurerId) {
                        const key = String(insurerId);
                        return Object.prototype.hasOwnProperty.call(this.form.insurers, key);
                    },

                    toggleInsurer(insurerId, checked) {
                        const key = String(insurerId);

                        if (checked) {
                            if (!this.isSelected(key)) this.form.insurers[key] = '';
                        } else {
                            if (this.isSelected(key)) delete this.form.insurers[key];
                        }
                    }
                }
            }
        </script>

    </div>
</x-app-layout>
