<?php

use App\Http\Controllers\DashboardController;
use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\InsurerController;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\InvoicePaymentController;
use App\Http\Controllers\InvoiceQueryController;
use App\Http\Controllers\PaymentController;

Route::get('/', function () {
    return view('welcome');
});


Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});
Route::middleware(['auth', 'verified'])->group(function () {
    Route::get('/dashboard', DashboardController::class)->name('dashboard');
    Route::resource('insurers', InsurerController::class)->except(['create', 'edit', 'show']);
    Route::resource('doctors', DoctorController::class)->except(['create', 'edit', 'show']);
    Route::resource('invoices', InvoiceController::class)->only(['index', 'store', 'destroy']);
    Route::get('invoices/preview-ncf', [InvoiceController::class, 'previewNcf'])
        ->name('invoices.preview-ncf');
    Route::get('invoices/doctor-data', [InvoiceController::class, 'doctorData'])
        ->name('invoices.doctor-data');

        Route::get('/doctors/{doctor}/insurers', [DoctorController::class, 'insurers'])
    ->name('doctors.insurers');

    Route::get('invoices/{invoice}', [InvoiceController::class, 'show'])
        ->name('invoices.show');

    Route::patch('invoices/{invoice}/void', [InvoiceController::class, 'void'])
        ->name('invoices.void');

        Route::get('/invoice-query', [InvoiceQueryController::class, 'index'])->name('invoice-query.index');
    Route::get('/invoice-query/search', [InvoiceQueryController::class, 'search'])->name('invoice-query.search');

    Route::post('invoices/{invoice}/payments', [InvoicePaymentController::class, 'store'])->name('invoices.payments.store');
    Route::delete('invoices/{invoice}/payments/{payment}', [InvoicePaymentController::class, 'destroy'])->name('invoices.payments.destroy');

    Route::get('/payments', [PaymentController::class, 'index'])->name('payments.index');
    Route::post('/payments', [PaymentController::class, 'store'])->name('payments.store');
    Route::delete('/payments/{payment}', [PaymentController::class, 'destroy'])->name('payments.destroy');

    // Endpoint para buscar facturas desde el módulo de pagos (AJAX)
    Route::get('/payments/invoice-search', [PaymentController::class, 'invoiceSearch'])->name('payments.invoice-search');
});




require __DIR__ . '/auth.php';
